/*
 * @(#)RERAttribute.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.rer.model;

import ch.hslu.cm.simulation.*;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
/**
 * Represents an RERAttribute of an Entity.
 * Important: equals and hashCode must be based on identity and not on the
 * attributes of this object.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 6. Februar 2004  Created.
 */
public class RERAttribute extends SimulatedAttribute {
    private boolean isPrimaryKey;
    private boolean isForeignKey;
    
    /** Creates a new instance. */
    public RERAttribute(String name) {
        this.name = name;
    }
    
    /**
     * This constructor is required for DOMStorable functionality.
     * Do <b>not</b> not use it for anything else.
     */
    public RERAttribute() {
    }
    
    public void setPrimaryKey(boolean newValue) {
        boolean oldValue = isPrimaryKey;
        isPrimaryKey = newValue;
        firePropertyChange("primaryKey", oldValue, newValue);
    }
    public boolean isPrimaryKey() {
        return isPrimaryKey;
    }
    public void setForeignKey(boolean newValue) {
        boolean oldValue = isForeignKey;
        isForeignKey = newValue;
        firePropertyChange("foreignKey", oldValue, newValue);
    }
    public boolean isForeignKey() {
        return isForeignKey;
    }
    
    public void read(DOMInput in) {
        super.read(in);
        isPrimaryKey = in.getAttribute("pk", false);
        isForeignKey = in.getAttribute("fk", false);
    }
    
    public void write(DOMOutput out) {
        super.write(out);
        out.addAttribute("pk", isPrimaryKey);
        out.addAttribute("fk", isForeignKey);
    }    
}
